/*  Die Beginn- und Endzeit der aktuellen Terminierung des Arbeitsganges zurück in den Arbeitsgang schreiben.
*/
SELECT tsystem.function__drop_by_regex( 'ab2__at_et__from__resource_timeline__sync', 'scheduling', _commit => true );
CREATE OR REPLACE FUNCTION scheduling.ab2__at_et__from__resource_timeline__sync( _a2_id int ) RETURNS void AS $$
  DECLARE
    _a2_at timestamp;
    _a2_et timestamp;
  BEGIN

      SELECT ti_date_start__min, ti_date_end__max
        INTO  _a2_at           , _a2_et
        FROM scheduling.ab2__resource_timeline__ti_date__min_max__get(_a2_id);


      -- abschalten "ab2__a_iu__termination_manual"  !!!!!!!!
      PERFORM execution_flag__aquire( _flagname => 'in_ab2__at_et__from__resource_timeline__sync' );

      UPDATE ab2
         SET a2_at = _a2_at,
             a2_et = _a2_et
       WHERE a2_id = _a2_id
         AND ( a2_at IS DISTINCT FROM _a2_at OR a2_et IS DISTINCT FROM _a2_et );

      PERFORM execution_flag__release( _flagname => 'in_ab2__at_et__from__resource_timeline__sync' );

      UPDATE ab2_wkstplan SET a2w_planweek = termweek(_a2_at), a2w_endweek = termweek(_a2_et) WHERE a2w_a2_id = _a2_id;

  END $$ LANGUAGE plpgsql;